
///////////////////////////////////////////////////////////////////////////////
//
//   CONEXANT SYSTEMS INC - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1192.C - Message 1192 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1192 messages.
//
//   Originator : Hao Q. Phung
//   REVISION HISTORY
//
//
//   $Log:   V:\Projects\Labmon\Source\Archives\msg1192.c_v  $ 
//   
//      Rev 1.0   08 Dec 1999 14:42:42   dangmk
//    
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1192 message from the ZMsgBuf.
//
void Dec1192(tMSGBUF *ZMsgBuf, tMSG1192 *Msg)
{

}                                      
                                     
   
//   Display a Zodiac 1192 message from the ZMsgBuf.
//
void Show1192(tMSG1192 *Msg)
{
	char Buf[30];

	switch (Msg->MagnaMode) 
	{
		case 0: sprintf(Buf,"    OFF");break;
		case 1: sprintf(Buf,"FASTACQ");break;
		case 2: sprintf(Buf,"     ON");break;
		default: sprintf(Buf,"UNKNOWN");break; 
	}
	ShowText(Buf,MAGR,MAGC+7);  
	
	switch (Msg->EnableLowCNo)
	{
		case 0: sprintf(Buf,"   34DB");break;
		case 1: sprintf(Buf,"   32DB");break;
		case 2: sprintf(Buf,"   30DB");break;
		case 3: sprintf(Buf,"   28DB");break;
		case 4: sprintf(Buf,"   26DB");break;
		case 5: sprintf(Buf,"   24DB");break;
		case 6: sprintf(Buf,"   22DB");break;
		case 7: sprintf(Buf,"   20DB");break;
		default: sprintf(Buf,"UNKNOWN");break;
	}
	ShowText(Buf,MAGR+1,MAGC+7);
	

	if(Msg->OKToPowerDown == 0)
		sprintf(Buf,"     NO"); 
	else
		sprintf(Buf,"    YES");
		
	ShowText(Buf,MAGR+2,MAGC+7);    
	
//	if(Msg->ContinuousTracking == 0)
//		sprintf(Buf,"NO");
//	else
//		sprintf(Buf,"YES");
//		
//	ShowText(Buf,MAGR,MAGC+9);
	
	sprintf(Buf,"%6ld",Msg->RTCInterval);
	ShowText(Buf,MAGR+3,MAGC+7); 
}                                                 
                                      
                                           
